rm(list=ls())
setwd("/Volumes/SHARE/data auctions/raw data FaceReader/Logs FPA")
library(foreign)
filenames<-list.files(getwd())
colnum<-c(2:9)
markers.profit<-c("IND_FPA display profit (!)","TEAM_FPA display profit (!)")
data.output<-data.frame(Session=integer(0), Subject=integer(0), Period=integer(0), Neutral=numeric(0), Happy=numeric(0), Sad=numeric(0), Angry=numeric(0), Surprised=numeric(0), Scared=numeric(0), Disgusted=numeric(0), Valence=numeric(0), emo_numobs=integer(0))

for (fname in 1:length(filenames)){
test.df<-read.table(filenames[fname],skip=8,sep="\t",header=TRUE)
for (i in 1:ncol(test.df)){
    test.df[,i]<-as.character(test.df[,i])
}
for (i in colnum){
    test.df[,i]<-as.numeric(test.df[,i])
}
seconds<-vector()
for (i in 1:nrow(test.df)) {
    times<-as.numeric(unlist(strsplit(test.df$Video.Time[i],":")))
    seconds<-c(seconds,times[1]*3600+times[2]*60+times[3])
}
test.df$Seconds<-seconds

Session<-rep(as.numeric(substr(filenames[fname],8,9)),12)
Subject<-rep(as.numeric(sub(".txt", "", sub(".*subject", "", filenames[fname]))),12)
Period<-seq(12)

Neutral<-vector()
Happy<-vector()
Sad<-vector()
Angry<-vector()
Surprised<-vector()
Scared<-vector()
Disgusted<-vector()
Valence<-vector()
emo_numobs<-vector()
emo_length<-10
marker_length<-60
start_sec<- -1
stop_sec<- -1
for (ri in 1:nrow(test.df)){
    if (start_sec==-1 & test.df$Event.Marker[ri] %in% markers.profit==FALSE){
        next
    }
    if (start_sec==-1){
        start_sec<-test.df$Seconds[ri]
    }
    curr_sec<-test.df$Seconds[ri]
    if (stop_sec==-1 & curr_sec-start_sec>emo_length){
        stop_sec<-test.df$Seconds[ri-1]
        Neutral<-c(Neutral,mean(test.df$Neutral[test.df$Seconds>=start_sec & test.df$Seconds<=stop_sec],na.rm=TRUE))
        Happy<-c(Happy,mean(test.df$Happy[test.df$Seconds>=start_sec & test.df$Seconds<=stop_sec],na.rm=TRUE))
        Sad<-c(Sad,mean(test.df$Sad[test.df$Seconds>=start_sec & test.df$Seconds<=stop_sec],na.rm=TRUE))
        Angry<-c(Angry,mean(test.df$Angry[test.df$Seconds>=start_sec & test.df$Seconds<=stop_sec],na.rm=TRUE))
        Surprised<-c(Surprised,mean(test.df$Surprised[test.df$Seconds>=start_sec & test.df$Seconds<=stop_sec],na.rm=TRUE))
        Scared<-c(Scared,mean(test.df$Scared[test.df$Seconds>=start_sec & test.df$Seconds<=stop_sec],na.rm=TRUE))
        Disgusted<-c(Disgusted,mean(test.df$Disgusted[test.df$Seconds>=start_sec & test.df$Seconds<=stop_sec],na.rm=TRUE))
        Valence<-c(Valence,mean(test.df$Valence[test.df$Seconds>=start_sec & test.df$Seconds<=stop_sec],na.rm=TRUE))
        emo_numobs<-c(emo_numobs,sum(!is.na(test.df$Happy[test.df$Seconds>=start_sec & test.df$Seconds<=stop_sec])))
    }
    if (curr_sec-start_sec>marker_length){
        start_sec<- -1
        stop_sec<- -1
    }
}
data.add<-cbind(Session,Subject,Period,Neutral,Happy,Sad,Angry,Surprised,Scared,Disgusted,Valence,emo_numobs)
data.output<-rbind(data.output,data.add)
}

write.dta(data.output, "/Volumes/SHARE/data auctions/raw data FaceReader/facereader_data.dta")

###################
# variable Valence not recorded in sessions 12 and 14 - create it using  the formula
# valence = happy - max(negative emotions)
rm(list=ls())
setwd("/Volumes/SHARE/data auctions/raw data FaceReader/Logs FPA")
library(foreign)
filenames<-c(list.files(getwd(),pattern="^session12"),list.files(getwd(),pattern="^session14"))
colnum<-c(2:8)
markers.profit<-c("IND_FPA display profit (!)","TEAM_FPA display profit (!)")
data.output<-data.frame(Session=integer(0), Subject=integer(0), Period=integer(0), Valence=numeric(0))
for (fname in 1:length(filenames)){
    test.df<-read.table(filenames[fname],skip=8,sep="\t",header=TRUE)
    for (i in 1:ncol(test.df)){
        test.df[,i]<-as.character(test.df[,i])
    }
    for (i in colnum){
        test.df[,i]<-as.numeric(test.df[,i])
    }
    seconds<-vector()
    for (i in 1:nrow(test.df)) {
        times<-as.numeric(unlist(strsplit(test.df$Video.Time[i],":")))
        seconds<-c(seconds,times[1]*3600+times[2]*60+times[3])
    }
test.df$Seconds<-seconds
test.df$Valence<-test.df$Happy-pmax(test.df$Sad,test.df$Angry,test.df$Scared,test.df$Disgusted)
    
Session<-rep(as.numeric(substr(filenames[fname],8,9)),12)
Subject<-rep(as.numeric(sub(".txt", "", sub(".*subject", "", filenames[fname]))),12)
Period<-seq(12)
Valence<-vector()
emo_length<-10
marker_length<-60
start_sec<- -1
stop_sec<- -1
for (ri in 1:nrow(test.df)){
    if (start_sec==-1 & test.df$Event.Marker[ri] %in% markers.profit==FALSE){
        next
    }
    if (start_sec==-1){
        start_sec<-test.df$Seconds[ri]
    }
    curr_sec<-test.df$Seconds[ri]
    if (stop_sec==-1 & curr_sec-start_sec>emo_length){
        stop_sec<-test.df$Seconds[ri-1]
        Valence<-c(Valence,mean(test.df$Valence[test.df$Seconds>=start_sec & test.df$Seconds<=stop_sec],na.rm=TRUE))
    }
    if (curr_sec-start_sec>marker_length){
        start_sec<- -1
        stop_sec<- -1
    }
}
data.add<-cbind(Session,Subject,Period,Valence)
data.output<-rbind(data.output,data.add)
}
write.dta(data.output, "/Volumes/SHARE/data auctions/raw data FaceReader/facereader_valence1214.dta")